/**
  ********************************************************************************
  *
  * @file    hal_t10.h
  * @brief   Header file of T10 driver
  *
  * @version V1.0
  * @data    22 Aug 2018
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  ********************************************************************************
  */


#ifndef __HAL_T10_H__
#define __HAL_T10_H__

#include <hic.h>
#include "type.h"


/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @addtogroup T10
  * @{
  */

/**
  * @defgroup t10_Public_Types t10 Public Types
  * @{
  */

/**
  * @brief Mode of t10
  */
typedef enum {
	T10_TIMER_MODE  = 0x0,
	T10_COUNT_MODE  = 0x1,
} t10_mode_t;

/**
  * @brief T10 count edge choose
  */
typedef enum {
	T10_UP_CNT   = 0x0,
	T10_DOWN_CNT = 0x1,
} t10_cnt_mode_t;

/**
  * @brief T10 pre clock division
  */
typedef enum {
	T10_CLK_DIV_2   = 0x0,
	T10_CLK_DIV_4   = 0x1,
	T10_CLK_DIV_8   = 0x2,
	T10_CLK_DIV_16  = 0x3,
	T10_CLK_DIV_32  = 0x4,
	T10_CLK_DIV_64  = 0x5,
	T10_CLK_DIV_128 = 0x6,
	T10_CLK_DIV_256 = 0x7,
} t10_prs_t;

/**
  * @brief  T10 handle Structure definition
  */
typedef struct t10_init_s {
	t10_mode_t mode;
	t10_cnt_mode_t cnt_mode;
	type_func_t pre_func;
	t10_prs_t prs;
} t10_init_t;

/**
  * @}
  */

/**
  * @defgroup T10_Private_Micros t10 private Micros
  * @{
  */
#define IS_T10_MODE_TYPE(x)			(((x) == T10_TIMER_MODE) || \
						 ((x) == T10_COUNT_MODE))
#define IS_T10_CNT_MODE_TYPE(x)			(((x) == T10_UP_CNT) || \
						 ((x) == T10_DOWN_CNT))
#define IS_T10_PRS_TYPE(x)			(((x) == T10_CLK_DIV_2)   || \
						 ((x) == T10_CLK_DIV_4)   || \
						 ((x) == T10_CLK_DIV_8)   || \
						 ((x) == T10_CLK_DIV_16)  || \
						 ((x) == T10_CLK_DIV_32)  || \
						 ((x) == T10_CLK_DIV_64)  || \
						 ((x) == ADC_CLKDIV_64)   || \
						 ((x) == T10_CLK_DIV_128) || \
						 ((x) == T10_CLK_DIV_256))

/**
  * @}
  */

/**
  * @addtogroup T10_Public_Functions
  * @{
  */  
hal_status_t t10_init(t10_init_t *init);
void t10_start(void);
uint8_t t10_get_value(void);
void t10_set_value(uint8_t data);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#endif /* __HAL_T10_H */
